-- Create database
CREATE DATABASE IF NOT EXISTS db_callv3;
USE db_callv3;

-- Create table for target numbers
CREATE TABLE IF NOT EXISTS target_numbers (
    id INT NOT NULL AUTO_INCREMENT,
    phone_number VARCHAR(20) NOT NULL,
    status ENUM('Success', '-', 'N/A') DEFAULT 'N/A',
    pressed_button VARCHAR(1) DEFAULT NULL,
    call_date DATETIME DEFAULT NULL,
    call_sid VARCHAR(50) DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id)
) ENGINE=InnoDB;

-- Create table for audio settings
CREATE TABLE IF NOT EXISTS audio_settings (
    id INT NOT NULL AUTO_INCREMENT,
    type ENUM('welcome', 'confirmation', 'error') NOT NULL,
    file_name VARCHAR(255) NOT NULL,
    file_path VARCHAR(255) NOT NULL,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    UNIQUE KEY unique_type (type)
) ENGINE=InnoDB; 