<?php
require_once 'includes/config.php';

if (isset($_GET['type'])) {
    $type = $_GET['type'];
    
    // Get audio file path from database
    $stmt = $db->prepare("SELECT file_path FROM audio_settings WHERE type = ?");
    $stmt->execute([$type]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result) {
        $filepath = AUDIO_UPLOAD_PATH . $result['file_path'];
        
        if (file_exists($filepath)) {
            // Set proper headers
            header('Content-Type: audio/mpeg');
            header('Content-Length: ' . filesize($filepath));
            header('Accept-Ranges: bytes');
            
            // Output file
            readfile($filepath);
            exit;
        }
    }
}

// If we get here, file not found
header('HTTP/1.0 404 Not Found');
echo 'Audio file not found'; 